﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.BO.View
{
    /// <summary>
    /// Suma dla zadanych parametrow szukania - albo dla klasy albo zwraca wynik dla studenta
    /// dane studenta wypelnione sa tylko w przypadku szukania po StudentID
    /// ID obiektu zwraca COUNT - czyli ilosc danych
    /// </summary>
    public class StatisticStudent : PI.FM.N000.Base.BL.BO.Base
    {
        public new class Search
        {
            public long? ClassID { get; set; }
            public long? StudentID { get; set; }
            public long? InstructorID { get; set; }
        }

        public StatisticStudent(Gemini.Core.BL.Interface.DBD.IDBDBase DBDBase)
            : base(DBDBase) { }

        public long? ClassID
        {
            get { return GetValue<long?>("ClassID"); }
            set { SetValue<long?>("ClassID", value); }
        }

        public string ClassName
        {
            get { return GetValue<string>("ClassName"); }
            set { SetValue<string>("ClassName", value); }
        }
        public string Forename
        {
            get { return GetValue<string>("Forename"); }
            set { SetValue<string>("Forename", value); }
        }
        public string Surename
        {
            get { return GetValue<string>("Surename"); }
            set { SetValue<string>("Surename", value); }
        }

        public int? CompetencePointsByWeight
        {
            get { return GetValue<int?>("CompetencePointsByWeight"); }
            set { SetValue<int?>("CompetencePointsByWeight", value); }
        }
        public int? CompetenceMaxPoints
        {
            get { return GetValue<int?>("CompetenceMaxPoints"); }
            set { SetValue<int?>("CompetenceMaxPoints", value); }
        }

        /// <summary>
        /// Punkty z Case Study rozumiemy jako ilość rozwiązanych rozdziałów
        /// </summary>
        public int? CaseStudyPoints
        {
            get { return GetValue<int?>("CaseStudyPoints"); }
            set { SetValue<int?>("CaseStudyPoints", value); }
        }

        /// <summary>
        /// Maksymalna ilość punktów z Case Study rozumiemy jako sume ilości wszystkich rozdziałów jakie rozwiązywał uczeń
        /// </summary>
        public int? CaseStudyMaxPoints
        {
            get { return GetValue<int?>("CaseStudyMaxPoints"); }
            set { SetValue<int?>("CaseStudyMaxPoints", value); }
        }

        public int? AdvancedTestStartPoints
        {
            get { return GetValue<int?>("AdvancedTestStartPoints"); }
            set { SetValue<int?>("AdvancedTestStartPoints", value); }
        }

        public int? AdvancedTestStartMaxPoints
        {
            get { return GetValue<int?>("AdvancedTestStartMaxPoints"); }
            set { SetValue<int?>("AdvancedTestStartMaxPoints", value); }
        }

        public int? AdvancedTestEndPoints
        {
            get { return GetValue<int?>("AdvancedTestEndPoints"); }
            set { SetValue<int?>("AdvancedTestEndPoints", value); }
        }

        public int? AdvancedTestEndMaxPoints
        {
            get { return GetValue<int?>("AdvancedTestEndMaxPoints"); }
            set { SetValue<int?>("AdvancedTestEndMaxPoints", value); }
        }

        public int? KnowledgeTestStartPoints
        {
            get { return GetValue<int?>("KnowledgeTestStartPoints"); }
            set { SetValue<int?>("KnowledgeTestStartPoints", value); }
        }

        public int? KnowledgeTestStartMaxPoints
        {
            get { return GetValue<int?>("KnowledgeTestStartMaxPoints"); }
            set { SetValue<int?>("KnowledgeTestStartMaxPoints", value); }
        }

        public int? KnowledgeTestEndPoints
        {
            get { return GetValue<int?>("KnowledgeTestEndPoints"); }
            set { SetValue<int?>("KnowledgeTestEndPoints", value); }
        }

        public int? KnowledgeTestEndMaxPoints
        {
            get { return GetValue<int?>("KnowledgeTestEndMaxPoints"); }
            set { SetValue<int?>("KnowledgeTestEndMaxPoints", value); }
        }

        public decimal? Salary
        {
            get { return GetValue<decimal?>("Salary"); }
            set { SetValue<decimal?>("Salary", value); }
        }

        public decimal? GameCash
        {
            get { return GetValue<decimal?>("GameCash"); }
            set { SetValue<decimal?>("GameCash", value); }
        }

        public int? ResetCount
        {
            get { return GetValue<int?>("ResetCount"); }
            set { SetValue<int?>("ResetCount", value); }
        }

        public int? CompetencePartDone
        {
            get { return GetValue<int?>("CompetencePartDone"); }
            set { SetValue<int?>("CompetencePartDone", value); }
        }
        
        public int AdvancedTestStartPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(AdvancedTestStartPoints, AdvancedTestStartMaxPoints);
            }
        }
        public int AdvancedTestEndPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(AdvancedTestEndPoints, AdvancedTestEndMaxPoints);
            }
        }
        public int KnowledgeTestStartPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(KnowledgeTestStartPoints, KnowledgeTestStartMaxPoints);
            }
        }
        public int KnowledgeTestEndPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(KnowledgeTestEndPoints, KnowledgeTestEndMaxPoints);
            }
        }
        public int CaseStudyPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(CaseStudyPoints, CaseStudyMaxPoints);
            }
        }
        public int CompetencePointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(CompetencePointsByWeight, CompetenceMaxPoints);
            }
        }
        public double CompetencePartDoneAvg
        {
            get
            {
                if (ResetCount.HasValue && CompetencePartDone.HasValue && CompetencePartDone > 0)
                {
                    return Convert.ToDouble(ResetCount) / Convert.ToDouble(CompetencePartDone);
                }
                return 0;
            }
        }
        public int SalaryAvg
        {
            get
            {
                if (ID > 0)
                {
                    return Convert.ToInt32(Salary / ID);
                }
                return 0;
            }
        }
        public int GameCashAvg
        {
            get
            {
                if (ID > 0)
                {
                    return Convert.ToInt32(GameCash / ID);
                }
                return 0;
            }
        }
        public int SalaryValue
        {
            get
            {
                return Salary.HasValue ? Convert.ToInt32(Salary) : 0;
            }
        }
        public int GameCashValue
        {
            get
            {
                return GameCash.HasValue ? Convert.ToInt32(GameCash) : 0;
            }
        }
    }
}